import { a341439e4e686906a } from "../internal/acf0e9bfb1cb9236c/a341439e4e686906a";
import { StarIO10Error } from "./StarIO10Error";
import { StarIO10ErrorCode } from "./StarIO10ErrorCode";
export class StarIO10UnprintableError extends StarIO10Error {
    status = undefined;
    constructor(message, errorCode = StarIO10ErrorCode.None, status = undefined) {
        super(message, errorCode);
        this.name = this.typeName;
        this.status = status;
    }
    get typeName() {
        return "StarIO10UnprintableError";
    }
    /* eslint-disable @typescript-eslint/no-explicit-any */
    generalize() {
        let statusString = undefined;
        if (this.status) {
            const statusInternal = new a341439e4e686906a(this.status);
            statusString = statusInternal.serialize();
        }
        const errorMap = {
            type: this.typeName,
            message: this.message,
            errorCode: this.errorCode,
            status: statusString,
        };
        const errorString = JSON.stringify(errorMap);
        const error = new Error(errorString);
        error.name = this.typeName;
        error.stack = this.stack; // スタックトレースを引き継ぐ
        return error;
    }
}
